#include <iostream>
#include <vector>
#include <algorithm>
#include <limits>

using namespace std;

long long calculate_max_army(int N, int S, vector<int>& mi, vector<int>& ai) {
    vector<long long> lo(N + 1, numeric_limits<long long>::min());
    vector<long long> hi(N + 1, numeric_limits<long long>::max());

    lo[0] = hi[0] = S;
    long long left_bound = 4, right_bound = 7;

    for (int i = 0; i < N; i++) {
        if (mi[i] == 1) {
            lo[i + 1] = max(lo[i + 1], 2 * lo[i] - ai[i]);
            hi[i + 1] = min(hi[i + 1], 2 * hi[i] - ai[i]);
        } else {
            long long tlo = (lo[i] + ai[i] + 1) / 2;
            long long thi = (hi[i] + ai[i]) / 2;

            lo[i + 1] = max(lo[i + 1], tlo);
            hi[i + 1] = min(hi[i + 1], thi);
        }

        if (lo[i + 1] > hi[i + 1] || hi[i + 1] < left_bound || lo[i + 1] > right_bound) {
            return hi[i];
        }

        left_bound = max(left_bound, 2 * left_bound - ai[i]);
        right_bound = min(right_bound, 2 * right_bound - ai[i]);

        if (i == N - 1) {
            return hi[i + 1];
        }
    }

    return -1;
}

int main() {
    int T;
    cin >> T;

    while (T--) {
        int N, S;
        cin >> N >> S;

        vector<int> mi(N), ai(N);
        for (int i = 0; i < N; i++) {
            cin >> mi[i];
        }
        for (int i = 0; i < N; i++) {
            cin >> ai[i];
        }

        long long result = calculate_max_army(N, S, mi, ai);
        if (result == -1) {
            cout << "nemoguce" << endl;
        } else {
            cout << result << endl;
        }
    }

    return 0;
}